<?php
/**
 * Template para card individual de post
 * 
 * @package Upgram
 * @since 1.27.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$post_id = get_the_ID();
$post_title = get_the_title();
$post_excerpt = get_the_excerpt();
$post_url = get_permalink();
$post_image = get_the_post_thumbnail_url($post_id, 'medium_large');
$post_date = get_the_date('d/m/Y');
?>

<article class="upgram-blog-post-card">
    <a href="<?php echo esc_url($post_url); ?>" class="upgram-blog-post-card-link">
        <div class="upgram-blog-post-card-image-wrapper">
            <?php if ($post_image) : ?>
                <img 
                    src="<?php echo esc_url($post_image); ?>" 
                    alt="<?php echo esc_attr($post_title); ?>"
                    class="upgram-blog-post-card-image"
                    loading="lazy"
                >
            <?php else : ?>
                <div class="upgram-blog-post-card-image-placeholder">
                    <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                        <circle cx="8.5" cy="8.5" r="1.5"></circle>
                        <polyline points="21 15 16 10 5 21"></polyline>
                    </svg>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="upgram-blog-post-card-content">
            <h2 class="upgram-blog-post-card-title">
                <?php echo esc_html($post_title); ?>
            </h2>
            
            <?php if ($post_excerpt) : ?>
                <p class="upgram-blog-post-card-excerpt">
                    <?php echo esc_html(wp_trim_words($post_excerpt, 20, '...')); ?>
                </p>
            <?php endif; ?>
            
            <div class="upgram-blog-post-card-meta">
                <span class="upgram-blog-post-card-date">
                    <?php echo esc_html($post_date); ?>
                </span>
            </div>
        </div>
    </a>
</article>



